/*
 * Decompiled with CFR 0.152.
 */
package com.solodevelopment.jumpboostenchant;

import com.solodevelopment.tokens.enchant.Enchantment;
import com.solodevelopment.tokens.nbt.NBT;
import com.solodevelopment.tokens.utils.FileSystem;
import java.util.Collections;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class JumpBoostEnchant
extends Enchantment {
    public String getName() {
        return "JumpBoost";
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(PlayerPickupItemEvent e) {
        ItemStack item;
        int held;
        Player player = e.getPlayer();
        int slot = player.getInventory().firstEmpty();
        if (slot == (held = player.getInventory().getHeldItemSlot()) && this.checkItem(item = e.getItem().getItemStack())) {
            this.giveEffect(player, item);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (e.getAction() == InventoryAction.NOTHING) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        int slot = e.getSlot();
        int heldSlot = player.getInventory().getHeldItemSlot();
        ItemStack currentItem = e.getCurrentItem();
        ItemStack heldItem = player.getInventory().getItem(heldSlot);
        if (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP)) {
            if (e.getHotbarButton() == heldSlot) {
                if (currentItem.equals((Object)heldItem)) {
                    return;
                }
                if (this.checkItem(heldItem)) {
                    this.removeEffect(player);
                }
                if (this.checkItem(currentItem)) {
                    this.giveEffect(player, currentItem);
                }
                return;
            }
            if (slot == heldSlot) {
                ItemStack hotbarItem = player.getInventory().getItem(e.getHotbarButton());
                if (this.checkItem(heldItem)) {
                    this.removeEffect(player);
                }
                if (this.checkItem(hotbarItem)) {
                    this.giveEffect(player, hotbarItem);
                }
            }
            return;
        }
        if (slot == heldSlot) {
            ItemStack cursorItem = e.getCursor();
            if (this.checkItem(currentItem)) {
                this.removeEffect(player);
            }
            if (this.checkItem(cursorItem)) {
                this.giveEffect(player, cursorItem);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent e) {
        Player player = e.getPlayer();
        ItemStack dropped = e.getItemDrop().getItemStack();
        if (this.checkItem(dropped)) {
            this.removeEffect(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemHeld(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        ItemStack held = player.getInventory().getItem(e.getNewSlot());
        if (this.checkItem(held)) {
            this.giveEffect(player, held);
        } else {
            this.removeEffect(player);
        }
    }

    public void create(FileSystem localFile) {
        localFile.set("enchant.configuration.custom-name", (Object)this.getName());
        localFile.set("enchant.configuration.display", (Object)("&c" + this.getName() + " %level%"));
        localFile.set("enchant.configuration.allowed-items", Collections.singletonList("DIAMOND_PICKAXE"));
        localFile.set("enchant.configuration.allowed-worlds", Collections.singletonList("world"));
        localFile.set("enchant.configuration.refundable", (Object)false);
        localFile.set("enchant.configuration.permission.enabled", (Object)false);
        localFile.set("enchant.configuration.permission.value", (Object)("tokens.enchant." + this.getName()));
        localFile.set("enchant.levels.configuration.max-level", (Object)250);
        localFile.set("enchant.levels.configuration.starting-price", (Object)0);
        localFile.set("enchant.levels.configuration.cost-algorithm", (Object)"(levels * 500) + startingPrice");
    }

    public void load(FileSystem localFile) {
        this.setEnchantName(localFile.getString("enchant.configuration.custom-name"));
        this.setDisplay(localFile.getString("enchant.configuration.display"));
        this.setAllowedItems(localFile.getStringList("enchant.configuration.allowed-items"));
        this.setRefundable(localFile.getBoolean("enchant.configuration.refundable"));
        if (localFile.getBoolean("enchant.configuration.permission.enabled")) {
            this.togglePermission();
            this.setPermission(localFile.getString("enchant.configuration.permission.value"));
        }
        this.setMaxLevel(localFile.getLong("enchant.levels.configuration.max-level"));
        this.setCostAlgorithm(localFile.getString("enchant.levels.configuration.cost-algorithm"));
        if (localFile.getString("enchant.levels.configuration.starting-price") != null) {
            this.setStartingPrice(localFile.getLong("enchant.levels.configuration.starting-price"));
        }
    }

    public void save(FileSystem localFile) {
    }

    private boolean checkItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (!this.hasMaterial(item.getType())) {
            return false;
        }
        String enchantName = this.getEnchantName();
        NBT itemNBT = NBT.get((ItemStack)item);
        return itemNBT.hasKey("Tokens" + enchantName);
    }

    private void removeEffect(Player player) {
        String enchantName = this.getEnchantName();
        if (player.hasMetadata("Tokens" + enchantName)) {
            player.removeMetadata("Tokens" + enchantName, (Plugin)tokensInstance);
            player.removePotionEffect(PotionEffectType.JUMP);
        }
    }

    private void giveEffect(Player player, ItemStack itemStack) {
        String enchantName = this.getEnchantName();
        NBT itemNBT = NBT.get((ItemStack)itemStack);
        long enchantLevel = itemNBT.getLong("Tokens" + enchantName);
        if (!player.hasMetadata("Tokens" + enchantName)) {
            player.setMetadata("Tokens" + this.getName(), (MetadataValue)new FixedMetadataValue((Plugin)tokensInstance, (Object)("Tokens" + enchantName)));
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 1000000, (int)enchantLevel - 1));
    }
}

