/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.utils.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import net.advancedplugins.heads.utils.reflect.IReflectionObject;
import net.advancedplugins.heads.utils.reflect.ReflectionUtil;

public class ReflectionConstructor
implements IReflectionObject {
    private Constructor<?> baseConstructor;

    public ReflectionConstructor(Constructor<?> constructor) {
        this.baseConstructor = constructor;
    }

    public ReflectionConstructor setAccessible(boolean bl) {
        this.baseConstructor.setAccessible(bl);
        return this;
    }

    public Constructor<?> getBase() {
        return this.baseConstructor;
    }

    public <T> T newInstance(Object ... objectArray) {
        try {
            return (T)this.baseConstructor.newInstance(objectArray);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    @Override
    public ReflectionUtil newCall() {
        return ReflectionUtil.newCall();
    }

    public ReflectionConstructor pass(Consumer<ReflectionConstructor> consumer) {
        consumer.accept(this);
        return this;
    }

    public ReflectionConstructor passIfValid(Consumer<ReflectionConstructor> consumer) {
        if (this.baseConstructor == null) {
            return this;
        }
        consumer.accept(this);
        return this;
    }
}

