/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.libs.apache.commons.math3.analysis.solvers;

import net.advancedplugins.heads.libs.apache.commons.math3.analysis.UnivariateFunction;
import net.advancedplugins.heads.libs.apache.commons.math3.analysis.solvers.AllowedSolution;
import net.advancedplugins.heads.libs.apache.commons.math3.analysis.solvers.BaseAbstractUnivariateSolver;
import net.advancedplugins.heads.libs.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import net.advancedplugins.heads.libs.apache.commons.math3.analysis.solvers.BrentSolver;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.MathIllegalArgumentException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.NoBracketingException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.NullArgumentException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.heads.libs.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnivariateSolverUtils {
    private UnivariateSolverUtils() {
    }

    public static double solve(UnivariateFunction univariateFunction, double d, double d2) throws NullArgumentException, NoBracketingException {
        try {
            if (univariateFunction == null) {
                throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
            }
        }
        catch (NullArgumentException nullArgumentException) {
            throw UnivariateSolverUtils.b(nullArgumentException);
        }
        BrentSolver brentSolver = new BrentSolver();
        return brentSolver.solve(Integer.MAX_VALUE, univariateFunction, d, d2);
    }

    public static double solve(UnivariateFunction univariateFunction, double d, double d2, double d3) throws NullArgumentException, NoBracketingException {
        try {
            if (univariateFunction == null) {
                throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
            }
        }
        catch (NullArgumentException nullArgumentException) {
            throw UnivariateSolverUtils.b(nullArgumentException);
        }
        BrentSolver brentSolver = new BrentSolver(d3);
        return brentSolver.solve(Integer.MAX_VALUE, univariateFunction, d, d2);
    }

    /*
     * Unable to fully structure code
     */
    public static double forceSide(int var0, UnivariateFunction var1_1, BracketedUnivariateSolver<UnivariateFunction> var2_2, double var3_3, double var5_4, double var7_5, AllowedSolution var9_6) throws NoBracketingException {
        var10_7 = BaseAbstractUnivariateSolver.b();
        try {
            if (var9_6 == AllowedSolution.ANY_SIDE) {
                return var3_3;
            }
        }
        catch (NoBracketingException v0) {
            throw UnivariateSolverUtils.b(v0);
        }
        var11_8 = FastMath.max(var2_2.getAbsoluteAccuracy(), FastMath.abs(var3_3 * var2_2.getRelativeAccuracy()));
        var13_9 = FastMath.max(var5_4, var3_3 - var11_8);
        var15_10 = var1_1.value(var13_9);
        var17_11 = FastMath.min(var7_5, var3_3 + var11_8);
        var19_12 = var1_1.value(var17_11);
        var21_13 = var0 - 2;
        while (var21_13 > 0) {
            block30: {
                block31: {
                    block32: {
                        block29: {
                            block28: {
                                try {
                                    block27: {
                                        try {
                                            try {
                                                try {
                                                    if (var15_10 >= 0.0 && var19_12 <= 0.0) break block27;
                                                }
                                                catch (NoBracketingException v1) {
                                                    throw UnivariateSolverUtils.b(v1);
                                                }
                                                if (!(var15_10 <= 0.0)) break block28;
                                            }
                                            catch (NoBracketingException v2) {
                                                throw UnivariateSolverUtils.b(v2);
                                            }
                                            if (!(var19_12 >= 0.0)) break block28;
                                        }
                                        catch (NoBracketingException v3) {
                                            throw UnivariateSolverUtils.b(v3);
                                        }
                                    }
                                    return var2_2.solve(var21_13, var1_1, var13_9, var17_11, var3_3, var9_6);
                                }
                                catch (NoBracketingException v4) {
                                    throw UnivariateSolverUtils.b(v4);
                                }
                            }
                            var22_14 = false;
                            var23_15 = false;
                            try {
                                if (var15_10 < var19_12) {
                                    if (!(var15_10 >= 0.0)) break block29;
                                }
                                ** GOTO lbl52
                            }
                            catch (NoBracketingException v5) {
                                throw UnivariateSolverUtils.b(v5);
                            }
                            var22_14 = true;
                            if (var10_7 == null) break block30;
                        }
                        var23_15 = true;
                        try {
                            try {
                                if (var10_7 == null) break block30;
lbl52:
                                // 2 sources

                                if (!(var15_10 > var19_12)) break block31;
                            }
                            catch (NoBracketingException v6) {
                                throw UnivariateSolverUtils.b(v6);
                            }
                            if (!(var15_10 <= 0.0)) break block32;
                        }
                        catch (NoBracketingException v7) {
                            throw UnivariateSolverUtils.b(v7);
                        }
                        var22_14 = true;
                        if (var10_7 == null) break block30;
                    }
                    var23_15 = true;
                    if (var10_7 == null) break block30;
                }
                var22_14 = true;
                var23_15 = true;
            }
            if (var22_14) {
                var13_9 = FastMath.max(var5_4, var13_9 - var11_8);
                var15_10 = var1_1.value(var13_9);
                --var21_13;
            }
            if (var23_15) {
                var17_11 = FastMath.min(var7_5, var17_11 + var11_8);
                var19_12 = var1_1.value(var17_11);
                --var21_13;
            }
            if (var10_7 == null) continue;
        }
        throw new NoBracketingException((Localizable)LocalizedFormats.FAILED_BRACKETING, var13_9, var17_11, var15_10, var19_12, new Object[]{var0 - var21_13, var0, var3_3, var5_4, var7_5});
    }

    public static double[] bracket(UnivariateFunction univariateFunction, double d, double d2, double d3) throws NullArgumentException, NotStrictlyPositiveException, NoBracketingException {
        return UnivariateSolverUtils.bracket(univariateFunction, d, d2, d3, 1.0, 1.0, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateFunction univariateFunction, double d, double d2, double d3, int n) throws NullArgumentException, NotStrictlyPositiveException, NoBracketingException {
        return UnivariateSolverUtils.bracket(univariateFunction, d, d2, d3, 1.0, 1.0, n);
    }

    public static double[] bracket(UnivariateFunction univariateFunction, double d, double d2, double d3, double d4, double d5, int n) throws NoBracketingException {
        MathIllegalArgumentException[] mathIllegalArgumentExceptionArray = BaseAbstractUnivariateSolver.b();
        try {
            if (univariateFunction == null) {
                throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
            }
        }
        catch (NoBracketingException noBracketingException) {
            throw UnivariateSolverUtils.b(noBracketingException);
        }
        try {
            if (d4 <= 0.0) {
                throw new NotStrictlyPositiveException(d4);
            }
        }
        catch (NoBracketingException noBracketingException) {
            throw UnivariateSolverUtils.b(noBracketingException);
        }
        try {
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INVALID_MAX_ITERATIONS, n);
            }
        }
        catch (NoBracketingException noBracketingException) {
            throw UnivariateSolverUtils.b(noBracketingException);
        }
        UnivariateSolverUtils.verifySequence(d2, d, d3);
        double d6 = d;
        double d7 = d;
        double d8 = Double.NaN;
        double d9 = Double.NaN;
        double d10 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d11;
            double d12;
            double d13;
            double d14;
            block21: {
                try {
                    if (!(d6 > d2) && !(d7 < d3)) break;
                }
                catch (NoBracketingException noBracketingException) {
                    throw UnivariateSolverUtils.b(noBracketingException);
                }
                d14 = d6;
                d13 = d8;
                d12 = d7;
                d11 = d9;
                d10 = d5 * d10 + d4;
                d6 = FastMath.max(d - d10, d2);
                d7 = FastMath.min(d + d10, d3);
                d8 = univariateFunction.value(d6);
                d9 = univariateFunction.value(d7);
                try {
                    try {
                        if (i != 0) break block21;
                        if (!(d8 * d9 <= 0.0)) continue;
                    }
                    catch (NoBracketingException noBracketingException) {
                        throw UnivariateSolverUtils.b(noBracketingException);
                    }
                    return new double[]{d6, d7};
                }
                catch (NoBracketingException noBracketingException) {
                    throw UnivariateSolverUtils.b(noBracketingException);
                }
            }
            try {
                if (d8 * d13 <= 0.0) {
                    return new double[]{d6, d14};
                }
            }
            catch (NoBracketingException noBracketingException) {
                throw UnivariateSolverUtils.b(noBracketingException);
            }
            try {
                if (!(d9 * d11 <= 0.0)) continue;
                return new double[]{d12, d7};
            }
            catch (NoBracketingException noBracketingException) {
                throw UnivariateSolverUtils.b(noBracketingException);
            }
        }
        throw new NoBracketingException(d6, d7, d8, d9);
    }

    public static double midpoint(double d, double d2) {
        return (d + d2) * 0.5;
    }

    public static boolean isBracketing(UnivariateFunction univariateFunction, double d, double d2) throws NullArgumentException {
        boolean bl;
        block13: {
            block12: {
                try {
                    if (univariateFunction == null) {
                        throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
                    }
                }
                catch (NullArgumentException nullArgumentException) {
                    throw UnivariateSolverUtils.b(nullArgumentException);
                }
                double d3 = univariateFunction.value(d);
                double d4 = univariateFunction.value(d2);
                try {
                    block11: {
                        try {
                            try {
                                try {
                                    if (d3 >= 0.0 && d4 <= 0.0) break block11;
                                }
                                catch (NullArgumentException nullArgumentException) {
                                    throw UnivariateSolverUtils.b(nullArgumentException);
                                }
                                if (!(d3 <= 0.0)) break block12;
                            }
                            catch (NullArgumentException nullArgumentException) {
                                throw UnivariateSolverUtils.b(nullArgumentException);
                            }
                            if (!(d4 >= 0.0)) break block12;
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw UnivariateSolverUtils.b(nullArgumentException);
                        }
                    }
                    bl = true;
                    break block13;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw UnivariateSolverUtils.b(nullArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isSequence(double d, double d2, double d3) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (!(d < d2) || !(d2 < d3)) break block4;
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw UnivariateSolverUtils.b(nullArgumentException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw UnivariateSolverUtils.b(nullArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static void verifyInterval(double d, double d2) throws NumberIsTooLargeException {
        try {
            if (d >= d2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d, d2, false);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw UnivariateSolverUtils.b(numberIsTooLargeException);
        }
    }

    public static void verifySequence(double d, double d2, double d3) throws NumberIsTooLargeException {
        UnivariateSolverUtils.verifyInterval(d, d2);
        UnivariateSolverUtils.verifyInterval(d2, d3);
    }

    public static void verifyBracketing(UnivariateFunction univariateFunction, double d, double d2) throws NullArgumentException, NoBracketingException {
        try {
            if (univariateFunction == null) {
                throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
            }
        }
        catch (NullArgumentException nullArgumentException) {
            throw UnivariateSolverUtils.b(nullArgumentException);
        }
        try {
            UnivariateSolverUtils.verifyInterval(d, d2);
            if (!UnivariateSolverUtils.isBracketing(univariateFunction, d, d2)) {
                throw new NoBracketingException(d, d2, univariateFunction.value(d), univariateFunction.value(d2));
            }
        }
        catch (NullArgumentException nullArgumentException) {
            throw UnivariateSolverUtils.b(nullArgumentException);
        }
    }

    private static MathIllegalArgumentException b(MathIllegalArgumentException mathIllegalArgumentException) {
        return mathIllegalArgumentException;
    }
}

