/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.advancedplugins.heads.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.heads.utils.ConfigItemCreator;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack is;
    private ItemMeta im;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.is = itemStack;
        this.im = itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int n) {
        this.is = new ItemStack(material, n);
        this.im = this.is.getItemMeta();
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.is = new ItemStack(material, n, (short)by);
        this.im = this.is.getItemMeta();
    }

    public ItemBuilder setDurability(short s) {
        this.is.setDurability(s);
        return this;
    }

    public ItemBuilder setName(String string) {
        this.im.setDisplayName(string);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.im.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.is.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.im;
            skullMeta.setOwner(string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int n) {
        this.im.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.is.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.is.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        this.im.setLore(Arrays.asList(stringArray));
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        this.im.setLore(list);
        this.is.setItemMeta(this.im);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ArrayList arrayList = new ArrayList(this.im.getLore());
        try {
            if (!arrayList.contains(string)) {
                return this;
            }
        }
        catch (ClassCastException classCastException) {
            throw ItemBuilder.b(classCastException);
        }
        arrayList.remove(string);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ArrayList arrayList;
        block4: {
            arrayList = new ArrayList(this.im.getLore());
            try {
                try {
                    if (n >= 0 && n <= arrayList.size()) break block4;
                }
                catch (ClassCastException classCastException) {
                    throw ItemBuilder.b(classCastException);
                }
                return this;
            }
            catch (ClassCastException classCastException) {
                throw ItemBuilder.b(classCastException);
            }
        }
        arrayList.remove(n);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.im.hasLore()) {
            arrayList = new ArrayList(this.im.getLore());
        }
        arrayList.add(string);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.im.getLore());
        arrayList.set(n, string);
        this.im.setLore(arrayList);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public ItemBuilder setColor(Color var1_1) {
        block2: {
            var2_2 = ConfigItemCreator.c();
            if (!(this.im instanceof LeatherArmorMeta)) ** GOTO lbl7
            var3_3 = (LeatherArmorMeta)this.im;
            try {
                var3_3.setColor(var1_1);
                if (!var2_2) break block2;
lbl7:
                // 2 sources

                if (!(this.im instanceof FireworkEffectMeta)) break block2;
            }
            catch (ClassCastException v0) {
                throw ItemBuilder.b(v0);
            }
            var3_3 = (FireworkEffectMeta)this.im;
            var3_3.setEffect(FireworkEffect.builder().withColor(var1_1).build());
        }
        return this;
    }

    public ItemBuilder setItemFlags(ItemFlag ... itemFlagArray) {
        this.im.addItemFlags(itemFlagArray);
        return this;
    }

    public ItemBuilder addAttribute(Attribute attribute, AttributeModifier attributeModifier) {
        this.im.addAttributeModifier(attribute, attributeModifier);
        return this;
    }

    public ItemBuilder setAmount(int n) {
        this.is.setAmount(n);
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        this.im.addItemFlags(new ItemFlag[]{itemFlag});
        return this;
    }

    public ItemBuilder setCustomModelData(Integer n) {
        try {
            if (MinecraftVersion.getVersionNumber() >= 1140) {
                this.im.setCustomModelData(n);
            }
        }
        catch (ClassCastException classCastException) {
            throw ItemBuilder.b(classCastException);
        }
        return this;
    }

    public ItemMeta getItemMeta() {
        return this.im;
    }

    public ItemStack toItemStack() {
        this.is.setItemMeta(this.im);
        return this.is;
    }

    private static ClassCastException b(ClassCastException classCastException) {
        return classCastException;
    }
}

