/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.libs.apache.commons.math3.util;

import java.math.BigDecimal;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.MathArithmeticException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.MathIllegalArgumentException;
import net.advancedplugins.heads.libs.apache.commons.math3.util.FastMath;

public class Precision {
    public static final double EPSILON;
    public static final double SAFE_MIN;
    private static final long EXPONENT_OFFSET = 1023L;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;
    private static final double POSITIVE_ZERO = 0.0;
    private static final long POSITIVE_ZERO_DOUBLE_BITS;
    private static final long NEGATIVE_ZERO_DOUBLE_BITS;
    private static final int POSITIVE_ZERO_FLOAT_BITS;
    private static final int NEGATIVE_ZERO_FLOAT_BITS;
    private static final String[] a;

    private Precision() {
    }

    public static int compareTo(double d, double d2, double d3) {
        try {
            if (Precision.equals(d, d2, d3)) {
                return 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Precision.b(numberFormatException);
        }
        try {
            if (d < d2) {
                return -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Precision.b(numberFormatException);
        }
        return 1;
    }

    public static int compareTo(double d, double d2, int n) {
        try {
            if (Precision.equals(d, d2, n)) {
                return 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Precision.b(numberFormatException);
        }
        try {
            if (d < d2) {
                return -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Precision.b(numberFormatException);
        }
        return 1;
    }

    public static boolean equals(float f, float f2) {
        return Precision.equals(f, f2, 1);
    }

    public static boolean equalsIncludingNaN(float f, float f2) {
        boolean bl;
        block14: {
            block10: {
                block13: {
                    boolean bl2;
                    boolean bl3;
                    block12: {
                        block11: {
                            try {
                                try {
                                    try {
                                        if (f == f && f2 == f2) break block10;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw Precision.b(numberFormatException);
                                    }
                                    if (f == f) break block11;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw Precision.b(numberFormatException);
                                }
                                bl3 = true;
                                break block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw Precision.b(numberFormatException);
                            }
                        }
                        bl3 = false;
                    }
                    try {
                        bl2 = f2 != f2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    try {
                        if (bl3 ^ bl2) break block13;
                        bl = true;
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = Precision.equals(f, f2, 1);
        }
        return bl;
    }

    public static boolean equals(float f, float f2, float f3) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (!Precision.equals(f, f2, 1) && !(FastMath.abs(f2 - f) <= f3)) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw Precision.b(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static boolean equalsIncludingNaN(float f, float f2, float f3) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (!Precision.equalsIncludingNaN(f, f2) && !(FastMath.abs(f2 - f) <= f3)) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw Precision.b(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equals(float var0, float var1_1, int var2_2) {
        block28: {
            block27: {
                block23: {
                    block26: {
                        block25: {
                            block29: {
                                block24: {
                                    block22: {
                                        block21: {
                                            var4_3 = Float.floatToRawIntBits(var0);
                                            var5_4 = Float.floatToRawIntBits(var1_1);
                                            var3_5 = FastMath.b();
                                            try {
                                                try {
                                                    if (((var4_3 ^ var5_4) & -2147483648) == 0) {
                                                        if (FastMath.abs(var4_3 - var5_4) > var2_2) break block21;
                                                    }
                                                    ** GOTO lbl22
                                                }
                                                catch (NumberFormatException v0) {
                                                    throw Precision.b(v0);
                                                }
                                                v1 = true;
                                                break block22;
                                            }
                                            catch (NumberFormatException v2) {
                                                throw Precision.b(v2);
                                            }
                                        }
                                        v1 = false;
                                    }
                                    var6_6 = v1;
                                    try {
                                        if (var3_5 != null) break block23;
lbl22:
                                        // 2 sources

                                        if (var4_3 >= var5_4) break block24;
                                    }
                                    catch (NumberFormatException v3) {
                                        throw Precision.b(v3);
                                    }
                                    var7_7 = var5_4 - Precision.POSITIVE_ZERO_FLOAT_BITS;
                                    var8_8 = var4_3 - Precision.NEGATIVE_ZERO_FLOAT_BITS;
                                    if (var3_5 != null) break block29;
                                }
                                var7_7 = var4_3 - Precision.POSITIVE_ZERO_FLOAT_BITS;
                                var8_8 = var5_4 - Precision.NEGATIVE_ZERO_FLOAT_BITS;
                            }
                            if (var7_7 <= var2_2) ** GOTO lbl38
                            var6_6 = false;
                            try {
                                try {
                                    if (var3_5 != null) break block23;
lbl38:
                                    // 2 sources

                                    if (var8_8 > var2_2 - var7_7) break block25;
                                }
                                catch (NumberFormatException v4) {
                                    throw Precision.b(v4);
                                }
                                v5 = true;
                                break block26;
                            }
                            catch (NumberFormatException v6) {
                                throw Precision.b(v6);
                            }
                        }
                        v5 = false;
                    }
                    var6_6 = v5;
                }
                try {
                    try {
                        try {
                            if (!var6_6 || Float.isNaN(var0)) break block27;
                        }
                        catch (NumberFormatException v7) {
                            throw Precision.b(v7);
                        }
                        if (Float.isNaN(var1_1)) break block27;
                    }
                    catch (NumberFormatException v8) {
                        throw Precision.b(v8);
                    }
                    v9 = true;
                    break block28;
                }
                catch (NumberFormatException v10) {
                    throw Precision.b(v10);
                }
            }
            v9 = false;
        }
        return v9;
    }

    public static boolean equalsIncludingNaN(float f, float f2, int n) {
        boolean bl;
        block14: {
            block10: {
                block13: {
                    boolean bl2;
                    boolean bl3;
                    block12: {
                        block11: {
                            try {
                                try {
                                    try {
                                        if (f == f && f2 == f2) break block10;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw Precision.b(numberFormatException);
                                    }
                                    if (f == f) break block11;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw Precision.b(numberFormatException);
                                }
                                bl3 = true;
                                break block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw Precision.b(numberFormatException);
                            }
                        }
                        bl3 = false;
                    }
                    try {
                        bl2 = f2 != f2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    try {
                        if (bl3 ^ bl2) break block13;
                        bl = true;
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = Precision.equals(f, f2, n);
        }
        return bl;
    }

    public static boolean equals(double d, double d2) {
        return Precision.equals(d, d2, 1);
    }

    public static boolean equalsIncludingNaN(double d, double d2) {
        boolean bl;
        block14: {
            block10: {
                block13: {
                    boolean bl2;
                    boolean bl3;
                    block12: {
                        block11: {
                            try {
                                try {
                                    try {
                                        if (d == d && d2 == d2) break block10;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw Precision.b(numberFormatException);
                                    }
                                    if (d == d) break block11;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw Precision.b(numberFormatException);
                                }
                                bl3 = true;
                                break block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw Precision.b(numberFormatException);
                            }
                        }
                        bl3 = false;
                    }
                    try {
                        bl2 = d2 != d2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    try {
                        if (bl3 ^ bl2) break block13;
                        bl = true;
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = Precision.equals(d, d2, 1);
        }
        return bl;
    }

    public static boolean equals(double d, double d2, double d3) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (!Precision.equals(d, d2, 1) && !(FastMath.abs(d2 - d) <= d3)) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw Precision.b(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static boolean equalsWithRelativeTolerance(double d, double d2, double d3) {
        boolean bl;
        try {
            if (Precision.equals(d, d2, 1)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Precision.b(numberFormatException);
        }
        double d4 = FastMath.max(FastMath.abs(d), FastMath.abs(d2));
        double d5 = FastMath.abs((d - d2) / d4);
        try {
            bl = d5 <= d3;
        }
        catch (NumberFormatException numberFormatException) {
            throw Precision.b(numberFormatException);
        }
        return bl;
    }

    public static boolean equalsIncludingNaN(double d, double d2, double d3) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (!Precision.equalsIncludingNaN(d, d2) && !(FastMath.abs(d2 - d) <= d3)) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw Precision.b(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equals(double var0, double var2_2, int var4_1) {
        block28: {
            block27: {
                block23: {
                    block26: {
                        block25: {
                            block29: {
                                block24: {
                                    block22: {
                                        block21: {
                                            var6_3 = Double.doubleToRawLongBits(var0);
                                            var8_4 = Double.doubleToRawLongBits(var2_2);
                                            var5_5 = FastMath.b();
                                            try {
                                                try {
                                                    if (((var6_3 ^ var8_4) & -9223372036854775808L) == 0L) {
                                                        if (FastMath.abs(var6_3 - var8_4) > (long)var4_1) break block21;
                                                    }
                                                    ** GOTO lbl22
                                                }
                                                catch (NumberFormatException v0) {
                                                    throw Precision.b(v0);
                                                }
                                                v1 = true;
                                                break block22;
                                            }
                                            catch (NumberFormatException v2) {
                                                throw Precision.b(v2);
                                            }
                                        }
                                        v1 = false;
                                    }
                                    var10_6 = v1;
                                    try {
                                        if (var5_5 != null) break block23;
lbl22:
                                        // 2 sources

                                        if (var6_3 >= var8_4) break block24;
                                    }
                                    catch (NumberFormatException v3) {
                                        throw Precision.b(v3);
                                    }
                                    var11_7 = var8_4 - Precision.POSITIVE_ZERO_DOUBLE_BITS;
                                    var13_8 = var6_3 - Precision.NEGATIVE_ZERO_DOUBLE_BITS;
                                    if (var5_5 != null) break block29;
                                }
                                var11_7 = var6_3 - Precision.POSITIVE_ZERO_DOUBLE_BITS;
                                var13_8 = var8_4 - Precision.NEGATIVE_ZERO_DOUBLE_BITS;
                            }
                            if (var11_7 <= (long)var4_1) ** GOTO lbl38
                            var10_6 = false;
                            try {
                                try {
                                    if (var5_5 != null) break block23;
lbl38:
                                    // 2 sources

                                    if (var13_8 > (long)var4_1 - var11_7) break block25;
                                }
                                catch (NumberFormatException v4) {
                                    throw Precision.b(v4);
                                }
                                v5 = true;
                                break block26;
                            }
                            catch (NumberFormatException v6) {
                                throw Precision.b(v6);
                            }
                        }
                        v5 = false;
                    }
                    var10_6 = v5;
                }
                try {
                    try {
                        try {
                            if (!var10_6 || Double.isNaN(var0)) break block27;
                        }
                        catch (NumberFormatException v7) {
                            throw Precision.b(v7);
                        }
                        if (Double.isNaN(var2_2)) break block27;
                    }
                    catch (NumberFormatException v8) {
                        throw Precision.b(v8);
                    }
                    v9 = true;
                    break block28;
                }
                catch (NumberFormatException v10) {
                    throw Precision.b(v10);
                }
            }
            v9 = false;
        }
        return v9;
    }

    public static boolean equalsIncludingNaN(double d, double d2, int n) {
        boolean bl;
        block14: {
            block10: {
                block13: {
                    boolean bl2;
                    boolean bl3;
                    block12: {
                        block11: {
                            try {
                                try {
                                    try {
                                        if (d == d && d2 == d2) break block10;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw Precision.b(numberFormatException);
                                    }
                                    if (d == d) break block11;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw Precision.b(numberFormatException);
                                }
                                bl3 = true;
                                break block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw Precision.b(numberFormatException);
                            }
                        }
                        bl3 = false;
                    }
                    try {
                        bl2 = d2 != d2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                    try {
                        if (bl3 ^ bl2) break block13;
                        bl = true;
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Precision.b(numberFormatException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = Precision.equals(d, d2, n);
        }
        return bl;
    }

    public static double round(double d, int n) {
        return Precision.round(d, n, 4);
    }

    public static double round(double d, int n, int n2) {
        try {
            double d2;
            double d3 = new BigDecimal(Double.toString(d)).setScale(n, n2).doubleValue();
            try {
                d2 = d3 == 0.0 ? 0.0 * d : d3;
            }
            catch (NumberFormatException numberFormatException) {
                throw Precision.b(numberFormatException);
            }
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (Double.isInfinite(d)) {
                    return d;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                throw Precision.b(numberFormatException2);
            }
            return Double.NaN;
        }
    }

    public static float round(float f, int n) {
        return Precision.round(f, n, 4);
    }

    public static float round(float f, int n, int n2) throws MathArithmeticException, MathIllegalArgumentException {
        float f2 = FastMath.copySign(1.0f, f);
        float f3 = (float)FastMath.pow(10.0, n) * f2;
        return (float)Precision.roundUnscaled(f * f3, f2, n2) / f3;
    }

    /*
     * Exception decompiling
     */
    private static double roundUnscaled(double var0, double var2_2, int var4_1) throws MathArithmeticException, MathIllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static double representableDelta(double d, double d2) {
        return d + d2 - d;
    }

    static {
        Object var6_6;
        String[] stringArray = new String[8];
        int n = 0;
        String string = "\u0006I*M^E\u007f\u001aH:@_Iy\u0015T&\b\u0006I*M^E\u007f\u0004\r\u0006I*M^Eb\u0015J9\\OJ\u000f\u0006I*M^Eb\u0015J9\\^U}\u001a\n\u0006I*M^En\u001bQ1\u000b\u0006I*M^El\u0018I0Q";
        int n2 = "\u0006I*M^E\u007f\u001aH:@_Iy\u0015T&\b\u0006I*M^E\u007f\u0004\r\u0006I*M^Eb\u0015J9\\OJ\u000f\u0006I*M^Eb\u0015J9\\^U}\u001a\n\u0006I*M^En\u001bQ1\u000b\u0006I*M^El\u0018I0Q".length();
        int n3 = 17;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            var6_6 = null;
            stringArray[n++] = Precision.a(63, Precision.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) break;
            n3 = string.charAt(n4);
        }
        string = "`/L+8#\u0004s,_:9*\t|\r`/L+8#\u000fw)U,2;";
        n2 = "`/L+8#\u0004s,_:9*\t|\r`/L+8#\u000fw)U,2;".length();
        n3 = 15;
        n4 = -1;
        while (true) {
            int n6 = ++n4;
            var6_6 = null;
            stringArray[n++] = Precision.a(89, Precision.a(string.substring(n6, n6 + n3)));
            if ((n4 += n3) >= n2) break;
            n3 = string.charAt(n4);
        }
        a = stringArray;
        POSITIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(0.0);
        NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
        POSITIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(0.0f);
        NEGATIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(-0.0f);
        EPSILON = Double.longBitsToDouble(4368491638549381120L);
        SAFE_MIN = Double.longBitsToDouble(0x10000000000000L);
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x15);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 107;
                        break;
                    }
                    case 1: {
                        n5 = 57;
                        break;
                    }
                    case 2: {
                        n5 = 64;
                        break;
                    }
                    case 3: {
                        n5 = 60;
                        break;
                    }
                    case 4: {
                        n5 = 37;
                        break;
                    }
                    case 5: {
                        n5 = 37;
                        break;
                    }
                    default: {
                        n5 = 21;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

