/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.libs.apache.commons.math3.random;

import java.util.Random;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.MathIllegalArgumentException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.heads.libs.apache.commons.math3.random.BitsStreamGenerator;
import net.advancedplugins.heads.libs.apache.commons.math3.random.RandomGenerator;

public class RandomGeneratorFactory {
    private RandomGeneratorFactory() {
    }

    public static RandomGenerator createRandomGenerator(final Random random) {
        return new RandomGenerator(){

            public void setSeed(int n) {
                random.setSeed(n);
            }

            public void setSeed(int[] nArray) {
                random.setSeed(RandomGeneratorFactory.convertToLong(nArray));
            }

            public void setSeed(long l) {
                random.setSeed(l);
            }

            public void nextBytes(byte[] byArray) {
                random.nextBytes(byArray);
            }

            public int nextInt() {
                return random.nextInt();
            }

            public int nextInt(int n) {
                try {
                    if (n <= 0) {
                        throw new NotStrictlyPositiveException(n);
                    }
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw 1.b(notStrictlyPositiveException);
                }
                return random.nextInt(n);
            }

            public long nextLong() {
                return random.nextLong();
            }

            public boolean nextBoolean() {
                return random.nextBoolean();
            }

            public float nextFloat() {
                return random.nextFloat();
            }

            public double nextDouble() {
                return random.nextDouble();
            }

            public double nextGaussian() {
                return random.nextGaussian();
            }

            private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
                return notStrictlyPositiveException;
            }
        };
    }

    public static long convertToLong(int[] nArray) {
        long l;
        block2: {
            long l2 = 0xFFFFFFFBL;
            long l3 = 0L;
            int[] nArray2 = nArray;
            MathIllegalArgumentException[] mathIllegalArgumentExceptionArray = BitsStreamGenerator.b();
            for (int n : nArray2) {
                l = l3 * 0xFFFFFFFBL + (long)n;
                if (mathIllegalArgumentExceptionArray == null) {
                    l3 = l;
                    if (mathIllegalArgumentExceptionArray == null) continue;
                }
                break block2;
            }
            l = l3;
        }
        return l;
    }
}

