/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.libs.apache.commons.math3.distribution;

import net.advancedplugins.heads.libs.apache.commons.math3.distribution.AbstractIntegerDistribution;
import net.advancedplugins.heads.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.heads.libs.apache.commons.math3.distribution.ExponentialDistribution;
import net.advancedplugins.heads.libs.apache.commons.math3.distribution.NormalDistribution;
import net.advancedplugins.heads.libs.apache.commons.math3.distribution.SaddlePointExpansion;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.heads.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.heads.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.heads.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.heads.libs.apache.commons.math3.special.Gamma;
import net.advancedplugins.heads.libs.apache.commons.math3.util.CombinatoricsUtils;
import net.advancedplugins.heads.libs.apache.commons.math3.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final ExponentialDistribution exponential;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double d) throws NotStrictlyPositiveException {
        this(d, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double d, double d2, int n) throws NotStrictlyPositiveException {
        this(new Well19937c(), d, d2, n);
    }

    public PoissonDistribution(RandomGenerator randomGenerator, double d, double d2, int n) throws NotStrictlyPositiveException {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d);
        }
        this.mean = d;
        this.epsilon = d2;
        this.maxIterations = n;
        this.normal = new NormalDistribution(randomGenerator, d, FastMath.sqrt(d), 1.0E-9);
        this.exponential = new ExponentialDistribution(randomGenerator, 1.0, 1.0E-9);
    }

    public PoissonDistribution(double d, double d2) throws NotStrictlyPositiveException {
        this(d, d2, 10000000);
    }

    public PoissonDistribution(double d, int n) {
        this(d, 1.0E-12, n);
    }

    public double getMean() {
        return this.mean;
    }

    public double probability(int n) {
        double d;
        double d2 = this.logProbability(n);
        try {
            d = d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw PoissonDistribution.b(notStrictlyPositiveException);
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public double logProbability(int var1_1) {
        block9: {
            block10: {
                var2_2 = AbstractRealDistribution.b();
                try {
                    if (var1_1 < 0 || var1_1 == 0x7FFFFFFF) {
                    }
                    ** GOTO lbl11
                }
                catch (NotStrictlyPositiveException v0) {
                    throw PoissonDistribution.b(v0);
                }
                var3_3 = -Infinity;
                try {
                    if (var2_2 != null) break block9;
lbl11:
                    // 2 sources

                    if (var1_1 != 0) break block10;
                }
                catch (NotStrictlyPositiveException v1) {
                    throw PoissonDistribution.b(v1);
                }
                var3_3 = -this.mean;
                if (var2_2 != null) break block9;
            }
            var3_3 = -SaddlePointExpansion.getStirlingError(var1_1) - SaddlePointExpansion.getDeviancePart(var1_1, this.mean) - 0.5 * FastMath.log(6.283185307179586) - 0.5 * FastMath.log(var1_1);
        }
        return var3_3;
    }

    public double cumulativeProbability(int n) {
        try {
            if (n < 0) {
                return 0.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw PoissonDistribution.b(notStrictlyPositiveException);
        }
        try {
            if (n == Integer.MAX_VALUE) {
                return 1.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw PoissonDistribution.b(notStrictlyPositiveException);
        }
        return Gamma.regularizedGammaQ((double)n + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int n) {
        return this.normal.cumulativeProbability((double)n + 0.5);
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        return this.getMean();
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        return (int)FastMath.min(this.nextPoisson(this.mean), Integer.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long nextPoisson(double var1_1) {
        var4_2 = 40.0;
        var3_3 = AbstractRealDistribution.b();
        if (var1_1 < 40.0) {
            var6_4 = FastMath.exp(-var1_1);
            var8_6 = 0L;
            var10_8 = 1.0;
            var12_10 = 1.0;
            while ((double)var8_6 < 1000.0 * var1_1) {
                var12_10 = this.random.nextDouble();
                if (!((var10_8 *= var12_10) >= var6_4)) return var8_6;
                ++var8_6;
                if (var3_3 != null) continue;
                return var8_6;
            }
            return var8_6;
        }
        var6_5 = FastMath.floor(var1_1);
        var8_7 = var1_1 - var6_5;
        var10_9 = FastMath.log(var6_5);
        var12_11 = CombinatoricsUtils.factorialLog((int)var6_5);
        try {
            v0 = var8_7 < 4.9E-324 ? 0L : this.nextPoisson(var8_7);
        }
        catch (NotStrictlyPositiveException v1) {
            throw PoissonDistribution.b(v1);
        }
        var14_12 = v0;
        var16_13 = FastMath.sqrt(var6_5 * FastMath.log(32.0 * var6_5 / 3.141592653589793 + 1.0));
        var18_14 = var16_13 / 2.0;
        var20_15 = 2.0 * var6_5 + var16_13;
        var22_16 = FastMath.sqrt(3.141592653589793 * var20_15) * FastMath.exp(1.0 / (8.0 * var6_5));
        var24_17 = var20_15 / var16_13 * FastMath.exp(-var16_13 * (1.0 + var16_13) / var20_15);
        var26_18 = var22_16 + var24_17 + 1.0;
        var28_19 = var22_16 / var26_18;
        var30_20 = var24_17 / var26_18;
        var32_21 = 1.0 / (8.0 * var6_5);
        var34_22 = 0.0;
        var36_23 = 0.0;
        var38_24 = 0.0;
        var40_25 = false;
        var41_26 = 0.0;
        var43_27 = 0.0;
        var45_28 = 0.0;
        while (true) {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            if (!((var47_29 = this.random.nextDouble()) <= var28_19)) ** GOTO lbl65
                            var49_30 = this.random.nextGaussian();
                            var34_22 = var49_30 * FastMath.sqrt(var6_5 + var18_14) - 0.5;
                            try {
                                v2 = var34_22 == var16_13 ? 0 : (var34_22 > var16_13 ? 1 : -1);
                                if (var3_3 == null) break block24;
                                if (v2 > 0) continue;
                            }
                            catch (NotStrictlyPositiveException v3) {
                                throw PoissonDistribution.b(v3);
                            }
                            try {
                                if (var34_22 < -var6_5 && var3_3 != null) continue;
                            }
                            catch (NotStrictlyPositiveException v4) {
                                throw PoissonDistribution.b(v4);
                            }
                            try {
                                v5 = var34_22 < 0.0 ? FastMath.floor(var34_22) : FastMath.ceil(var34_22);
                            }
                            catch (NotStrictlyPositiveException v6) {
                                throw PoissonDistribution.b(v6);
                            }
                            var36_23 = v5;
                            var51_31 = this.exponential.sample();
                            var38_24 = -var51_31 - var49_30 * var49_30 / 2.0 + var32_21;
                            try {
                                if (var3_3 != null) break block25;
lbl65:
                                // 2 sources

                                v2 = (cfr_temp_0 = var47_29 - (var28_19 + var30_20)) == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
                            }
                            catch (NotStrictlyPositiveException v7) {
                                throw PoissonDistribution.b(v7);
                            }
                        }
                        if (v2 > 0) {
                            var36_23 = var6_5;
                            if (var3_3 != null) return var14_12 + (long)var36_23;
                        }
                        var34_22 = var16_13 + var20_15 / var16_13 * this.exponential.sample();
                        var36_23 = FastMath.ceil(var34_22);
                        var38_24 = -this.exponential.sample() - var16_13 * (var34_22 + 1.0) / var20_15;
                    }
                    try {
                        v8 = var34_22 < 0.0;
                    }
                    catch (NotStrictlyPositiveException v9) {
                        throw PoissonDistribution.b(v9);
                    }
                    var40_25 = v8;
                    var41_26 = var36_23 * (var36_23 + 1.0) / (2.0 * var6_5);
                    try {
                        if (!(var38_24 < -var41_26) || var40_25) break block26;
                    }
                    catch (NotStrictlyPositiveException v10) {
                        throw PoissonDistribution.b(v10);
                    }
                    var36_23 = var6_5 + var36_23;
                    if (var3_3 != null) return var14_12 + (long)var36_23;
                }
                if (!(var38_24 < (var45_28 = (var43_27 = var41_26 * ((2.0 * var36_23 + 1.0) / (6.0 * var6_5) - 1.0)) - var41_26 * var41_26 / (3.0 * (var6_5 + (double)var40_25 * (var36_23 + 1.0)))))) ** GOTO lbl96
                var36_23 = var6_5 + var36_23;
                try {
                    try {
                        if (var3_3 != null) return var14_12 + (long)var36_23;
lbl96:
                        // 2 sources

                        if (!(var38_24 > var43_27)) break block27;
                    }
                    catch (NotStrictlyPositiveException v11) {
                        throw PoissonDistribution.b(v11);
                    }
                    if (var3_3 != null) continue;
                }
                catch (NotStrictlyPositiveException v12) {
                    throw PoissonDistribution.b(v12);
                }
            }
            if (!(var38_24 < var36_23 * var10_9 - CombinatoricsUtils.factorialLog((int)(var36_23 + var6_5)) + var12_11)) ** GOTO lbl109
            var36_23 = var6_5 + var36_23;
            if (var3_3 != null) return var14_12 + (long)var36_23;
lbl109:
            // 2 sources

            if (var3_3 == null) return var14_12 + (long)var36_23;
            continue;
            break;
        }
        catch (NotStrictlyPositiveException v13) {
            throw PoissonDistribution.b(v13);
        }
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

